#define LIGHTING
#define NONORMAL
#include "InventorBasicEffectDx9.fxh"

//float2 g_InverseViewPort: InverseViewPortSize;

struct VSPosTex
{
	float3 Pos		: Position;
	float4 offTex		: Color;//xy: position offset; zw: texture coordinate
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_PosTex( VSPosTex Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);
	float4 outpos = mul(LocalPos,g_matWorldViewProj);
	
	//Perspective divide
	outpos.xyz /= outpos.w;
	outpos.w = 1.0f;
	
	//When drawing image, it starts with a marker point in model space.
	//The other 3 points would be decided in npc space. There are 3 offsets needed in npc space. WG
	outpos.xy += Input.offTex.xy*2.0f/g_ViewPort;
	outpos.xy += float2(-1.0f/g_ViewPort.x, -1.0f/g_ViewPort.y);//offset 1/2 pixel again.

	Out.Pos = outpos;

	//float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
	if(g_enabledLight)
	{
		float Opacity = g_Misc.y;
		TripleColor Color = CalcLightingAmb(Input.Pos,g_Emissive, g_Ambient,Opacity);
		Out.ColorD = Color.Diffuse;
	}else
	{
		Out.ColorD = g_Emissive;
	}
	Out.ColorD.w = g_Misc.y;

#ifdef DIFFUSE_TEXTURE
	Out.Tex = float4(Input.offTex.zw, 0.0f, 1.0f);
	Out.Tex = mul(Out.Tex, g_matDiffTex);
#endif

	if(g_fogEnabled)
	{
		float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
		Out.ColorSAndFogFactor.w = CalcFogFactor(ViewPos.z);
	}


	return Out;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------

float4 PS_PosTex( PSInput Input ) : COLOR0
{
#ifdef DIFFUSE_TEXTURE
	CalcDiffuseTexture(Input);
#endif
	if(Input.ColorD.a < g_Misc.w)
		discard;
	float4 Color=(float4)0;
	Color.xyz = saturate(Input.ColorD.xyz + Input.ColorSAndFogFactor.xyz);
	Color.a = Input.ColorD.a;

	if(g_fogEnabled)
	{
		float FogFactor = Input.ColorSAndFogFactor.w;
		return FogFactor * Color + (1.0 - FogFactor) * g_fogColor;
	}
	else
		return Color;
}

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique PosTex
{
    pass P0
    {   
		VertexShader = compile vs_2_0 VS_PosTex();
		PixelShader = compile ps_2_0 PS_PosTex();
    }
}